<?php
/**
 * Banner API
 * Mobil uygulama için banner verilerini sağlar
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once __DIR__ . '/../config/database.php';

try {
    $database = new Database();
    $db = $database->getConnection();
    
    $action = $_GET['action'] ?? 'get_banners';
    
    switch ($action) {
        case 'get_banners':
            $banner_type = $_GET['type'] ?? 'verse_top';
            
            // Aktif banner'ları getir
            $stmt = $db->prepare("
                SELECT id, title, description, image_path, banner_type, click_url, view_count, click_count
                FROM app_banners 
                WHERE is_active = 1 
                AND banner_type = ?
                AND (start_date IS NULL OR start_date <= NOW())
                AND (end_date IS NULL OR end_date >= NOW())
                ORDER BY sort_order ASC, created_at DESC
            ");
            $stmt->execute([$banner_type]);
            $banners = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Görsel URL'lerini dinamik olarak oluştur (HTTPS/HTTP + host + doğru uploads yolu)
            $protocol = 'http';
            if ((!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https')) {
                $protocol = 'https';
            }
            $host = $_SERVER['HTTP_HOST'] ?? '';
            $scriptDir = dirname($_SERVER['SCRIPT_NAME'] ?? '/'); // ör: /adminpanel/api
            $baseDir = dirname($scriptDir); // ör: /adminpanel
            $uploadsPath = $baseDir . '/uploads/'; // ör: /adminpanel/uploads/

            foreach ($banners as &$banner) {
                if (!empty($banner['image_path'])) {
                    // image_path admin panelde 'banners/<filename>' olarak kaydediliyor
                    $banner['image_url'] = $protocol . '://' . $host . $uploadsPath . $banner['image_path'];
                } else {
                    $banner['image_url'] = null;
                }
            }
            
            echo json_encode([
                'success' => true,
                'banners' => $banners,
                'count' => count($banners)
            ]);
            break;
            
        case 'track_view':
            $banner_id = (int)($_POST['banner_id'] ?? 0);
            
            if ($banner_id <= 0) {
                throw new Exception("Geçersiz banner ID");
            }
            
            // Banner görüntülenme sayısını artır
            $stmt = $db->prepare("UPDATE app_banners SET view_count = view_count + 1 WHERE id = ?");
            $stmt->execute([$banner_id]);
            
            // İstatistik tablosuna kaydet
            $today = date('Y-m-d');
            $stmt = $db->prepare("
                INSERT INTO banner_stats (banner_id, date_viewed, view_count, device_type) 
                VALUES (?, ?, 1, 'mobile')
                ON DUPLICATE KEY UPDATE view_count = view_count + 1
            ");
            $stmt->execute([$banner_id, $today]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Görüntülenme kaydedildi'
            ]);
            break;
            
        case 'track_click':
            $banner_id = (int)($_POST['banner_id'] ?? 0);
            
            if ($banner_id <= 0) {
                throw new Exception("Geçersiz banner ID");
            }
            
            // Banner tıklama sayısını artır
            $stmt = $db->prepare("UPDATE app_banners SET click_count = click_count + 1 WHERE id = ?");
            $stmt->execute([$banner_id]);
            
            // İstatistik tablosuna kaydet
            $today = date('Y-m-d');
            $stmt = $db->prepare("
                INSERT INTO banner_stats (banner_id, date_viewed, click_count, device_type) 
                VALUES (?, ?, 1, 'mobile')
                ON DUPLICATE KEY UPDATE click_count = click_count + 1
            ");
            $stmt->execute([$banner_id, $today]);
            
            echo json_encode([
                'success' => true,
                'message' => 'Tıklama kaydedildi'
            ]);
            break;
            
        default:
            throw new Exception("Geçersiz işlem");
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
