<?php
ob_start();
/**
 * Admin Panel Header Layout
 * Namaz Vakitleri Admin Panel
 */

// Session kontrolü
if (!isset($_SESSION)) {
    session_start();
}

// Login kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    if (basename($_SERVER['PHP_SELF']) !== 'login.php') {
        header('Location: login.php');
        exit();
    }
}

// Aktif sayfa belirleme
$current_page = basename($_SERVER['PHP_SELF'], '.php');
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? $page_title . ' - ' : ''; ?>Namaz Vakti Pro Admin Panel</title>
    
    <!-- CSS Files -->
    <?php
    // Dark mode cookie kontrolü
    $isDarkMode = isset($_COOKIE['dark_mode']) && $_COOKIE['dark_mode'] === 'true';
    $cssFile = $isDarkMode ? 'assets/css/admin-style-dark.css' : 'assets/css/admin-style.css';
    ?>
    <link rel="stylesheet" href="<?php echo $cssFile; ?>">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Custom Page CSS -->
    <?php if (isset($custom_css)): ?>
        <?php foreach ($custom_css as $css): ?>
            <link rel="stylesheet" href="<?php echo $css; ?>">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    <div class="admin-container">
        <!-- Sidebar -->
        <nav class="sidebar">
            <div class="sidebar-header">
                <h2>Namaz Vakitleri</h2>
                <p>Admin Panel</p>
            </div>
            
            <div class="sidebar-menu">
                <a href="dashboard.php" class="menu-item <?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                    <i class="fas fa-tachometer-alt"></i>
                    Dashboard
                </a>
                
                <a href="story-cards.php" class="menu-item <?php echo $current_page === 'story-cards' ? 'active' : ''; ?>">
                    <i class="fas fa-images"></i>
                    Story Kartları
                </a>
                
                <a href="story-add.php" class="menu-item <?php echo $current_page === 'story-add' ? 'active' : ''; ?>">
                    <i class="fas fa-plus-circle"></i>
                    Yeni Story Ekle
                </a>
                
                <a href="notifications.php" class="menu-item <?php echo $current_page === 'notifications' ? 'active' : ''; ?>">
                    <i class="fas fa-bell"></i>
                    Bildirim Gönder
                </a>
                
                <a href="notification-history.php" class="menu-item <?php echo $current_page === 'notification-history' ? 'active' : ''; ?>">
                    <i class="fas fa-history"></i>
                    Bildirim Geçmişi
                </a>
                
                <a href="api-settings.php" class="menu-item <?php echo $current_page === 'api-settings' ? 'active' : ''; ?>">
                    <i class="fas fa-key"></i>
                    API Ayarları
                </a>
                
                <a href="banner-management.php" class="menu-item <?php echo $current_page === 'banner-management' ? 'active' : ''; ?>">
                    <i class="fas fa-ad"></i>
                    Banner Yönetimi
                </a>
                
                <div class="menu-divider"></div>
                
                <div class="menu-section">
                    <span class="menu-section-title">Dua Kardeşliği</span>
                </div>
                
                <a href="dua-users.php" class="menu-item <?php echo $current_page === 'dua-users' ? 'active' : ''; ?>">
                    <i class="fas fa-users"></i>
                    Kullanıcı Yönetimi
                </a>
                
                <a href="dua-requests.php" class="menu-item <?php echo $current_page === 'dua-requests' ? 'active' : ''; ?>">
                    <i class="fas fa-hands-praying"></i>
                    Dua Talepleri
                </a>
                
                <a href="dua-comments.php" class="menu-item <?php echo $current_page === 'dua-comments' ? 'active' : ''; ?>">
                    <i class="fas fa-comments"></i>
                    Yorum Yönetimi
                </a>
                
                <a href="reports.php" class="menu-item <?php echo $current_page === 'reports' ? 'active' : ''; ?>">
                    <i class="fas fa-chart-pie"></i>
                    Raporlar
                </a>
                
                <div class="menu-divider"></div>
                
                <a href="change-password.php" class="menu-item <?php echo $current_page === 'change-password' ? 'active' : ''; ?>">
                    <i class="fas fa-lock"></i>
                    Şifre Değiştirme
                </a>
                
                <a href="logout.php" class="menu-item">
                    <i class="fas fa-sign-out-alt"></i>
                    Çıkış Yap
                </a>
            </div>
        </nav>
        
        <!-- Main Content -->
        <main class="main-content">
            <!-- Header -->
            <header class="admin-header">
                <div class="header-title">
                    <h1><?php echo isset($page_title) ? $page_title : 'Dashboard'; ?></h1>
                </div>
                
                <div class="header-actions">
                    <?php if (isset($header_actions)): ?>
                        <?php echo $header_actions; ?>
                    <?php endif; ?>
                    
                    <div class="user-info">
                        <span>Hoş geldiniz, <?php echo isset($_SESSION['admin_name']) ? $_SESSION['admin_name'] : 'Admin'; ?></span>
                    </div>
                </div>
            </header>
            
            <!-- Content Area -->
            <div class="content-area">
                <?php
                // Alert mesajlarını göster
                if (isset($_SESSION['success_message'])) {
                    echo '<div class="alert alert-success">' . $_SESSION['success_message'] . '</div>';
                    unset($_SESSION['success_message']);
                }
                
                if (isset($_SESSION['error_message'])) {
                    echo '<div class="alert alert-error">' . $_SESSION['error_message'] . '</div>';
                    unset($_SESSION['error_message']);
                }
                
                if (isset($_SESSION['warning_message'])) {
                    echo '<div class="alert alert-warning">' . $_SESSION['warning_message'] . '</div>';
                    unset($_SESSION['warning_message']);
                }
                
                if (isset($_SESSION['info_message'])) {
                    echo '<div class="alert alert-info">' . $_SESSION['info_message'] . '</div>';
                    unset($_SESSION['info_message']);
                }