<?php
/**
 * API Ayarları Endpoint
 * Mobil uygulama için API Key servisi
 */

// CORS headers
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// OPTIONS request için
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config/database.php';

// Database bağlantısı
try {
    $database = new Database();
    $db = $database->getConnection();
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'message' => 'Database bağlantı hatası: ' . $e->getMessage()
    ]);
    exit();
}

// Content-Type header
header('Content-Type: application/json');

// GET isteği - Gemini API Key'i getir
if (isset($_GET['action']) && $_GET['action'] === 'get_gemini') {
    try {
        $stmt = $db->prepare("SELECT api_key FROM api_config WHERE api_name = 'gemini_api' AND is_active = 1");
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result && !empty($result['api_key'])) {
            echo json_encode([
                'success' => true,
                'api_key' => $result['api_key']
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Aktif Gemini API Key bulunamadı'
            ]);
        }
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'API Key getirme hatası: ' . $e->getMessage()
        ]);
    }
    exit();
}

// GET isteği - Tüm API'leri getir
if (isset($_GET['action']) && $_GET['action'] === 'get_all') {
    try {
        $stmt = $db->prepare("SELECT * FROM api_config ORDER BY api_name");
        $stmt->execute();
        $apis = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        echo json_encode([
            'success' => true,
            'apis' => $apis
        ]);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode([
            'success' => false,
            'message' => 'API listesi getirme hatası: ' . $e->getMessage()
        ]);
    }
    exit();
}

// POST isteği - API Key güncelleme
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!$input) {
        http_response_code(400);
        echo json_encode([
            'success' => false,
            'message' => 'Geçersiz JSON verisi'
        ]);
        exit();
    }
    
    $action = $input['action'] ?? '';
    
    switch ($action) {
        case 'update_gemini':
            $apiKey = trim($input['api_key'] ?? '');
            
            if (empty($apiKey)) {
                http_response_code(400);
                echo json_encode([
                    'success' => false,
                    'message' => 'API Key boş olamaz'
                ]);
                exit();
            }
            
            try {
                // Gemini API Key'i güncelle veya ekle
                $stmt = $db->prepare("
                    INSERT INTO api_config (api_name, api_key, description, is_active) 
                    VALUES ('gemini_api', ?, 'Google Gemini AI API Key', 1)
                    ON DUPLICATE KEY UPDATE 
                    api_key = VALUES(api_key), 
                    updated_at = CURRENT_TIMESTAMP,
                    is_active = 1
                ");
                
                if ($stmt->execute([$apiKey])) {
                    echo json_encode([
                        'success' => true,
                        'message' => 'Gemini API Key başarıyla güncellendi'
                    ]);
                } else {
                    throw new Exception("API Key güncellenirken hata oluştu");
                }
            } catch (Exception $e) {
                http_response_code(500);
                echo json_encode([
                    'success' => false,
                    'message' => 'API Key güncelleme hatası: ' . $e->getMessage()
                ]);
            }
            break;
            
        default:
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'Geçersiz action parametresi'
            ]);
            break;
    }
    exit();
}

// Desteklenmeyen method
http_response_code(405);
echo json_encode([
    'success' => false,
    'message' => 'Desteklenmeyen HTTP method'
]);
?>
