<?php
/**
 * Story Silme API
 * Namaz Vakitleri Admin Panel
 */

header('Content-Type: application/json');

// Session kontrolü
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Yetkisiz erişim']);
    exit();
}

require_once __DIR__ . '/../config/database.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Sadece POST metodu desteklenir']);
    exit();
}

$story_id = (int)($_POST['id'] ?? 0);

if ($story_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz story ID']);
    exit();
}

try {
    $db = getDB();
    
    // Story bilgilerini al
    $stmt = $db->prepare("SELECT * FROM story_cards WHERE id = ?");
    $stmt->execute([$story_id]);
    $story = $stmt->fetch();
    
    if (!$story) {
        echo json_encode(['success' => false, 'message' => 'Story bulunamadı']);
        exit();
    }
    
    // Story'yi sil
    $stmt = $db->prepare("DELETE FROM story_cards WHERE id = ?");
    $stmt->execute([$story_id]);
    
    // Görsel dosyasını sil
    if (!empty($story['image_path']) && file_exists(__DIR__ . '/../uploads/' . $story['image_path'])) {
        unlink(__DIR__ . '/../uploads/' . $story['image_path']);
    }
    
    echo json_encode(['success' => true, 'message' => 'Story başarıyla silindi']);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Veritabanı hatası: ' . $e->getMessage()]);
}
?>
