<?php
/**
 * Database Bağlantı Konfigürasyonu
 * Namaz Vakitleri Admin Panel
 */

class Database {
    private $host = 'localhost';
    private $db_name = 'tarifgpt_NamazDost';
    private $username = 'tarifgpt_NamazDost';
    private $password = 'p.Q*55KY2Pecc1';
    private $charset = 'utf8mb4';
    public $conn;

    /**
     * Database bağlantısı oluştur
     */
    public function getConnection() {
        $this->conn = null;
        
        try {
            $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=" . $this->charset;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci"
            ];
            
            error_log("Database bağlantısı deneniyor: " . $dsn);
            $this->conn = new PDO($dsn, $this->username, $this->password, $options);
            error_log("Database bağlantısı başarılı!");
            
        } catch(PDOException $exception) {
            error_log("Database bağlantı hatası: " . $exception->getMessage());
            throw new Exception("Database bağlantı hatası: " . $exception->getMessage());
        }
        
        return $this->conn;
    }

    /**
     * Database bağlantısını kapat
     */
    public function closeConnection() {
        $this->conn = null;
    }

    /**
     * Son eklenen ID'yi al
     */
    public function lastInsertId() {
        return $this->conn->lastInsertId();
    }

    /**
     * Transaction başlat
     */
    public function beginTransaction() {
        return $this->conn->beginTransaction();
    }

    /**
     * Transaction commit et
     */
    public function commit() {
        return $this->conn->commit();
    }

    /**
     * Transaction rollback yap
     */
    public function rollback() {
        return $this->conn->rollback();
    }
}

/**
 * Global database bağlantı fonksiyonu
 */
function getDB() {
    static $database = null;
    if ($database === null) {
        $database = new Database();
    }
    return $database->getConnection();
}
?>
