<?php
/**
 * Firebase Ayarları İşleme Dosyası
 * Firebase HTTP v1 API ayarlarını kaydetme ve getirme
 */

session_start();
require_once 'config/database.php';

// Admin kontrolü
if (!isset($_SESSION['admin_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Yetkisiz erişim']);
    exit();
}

// Database bağlantısı
$database = new Database();
$db = $database->getConnection();

// GET isteği - Mevcut ayarları getir
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['action']) && $_GET['action'] === 'get') {
    try {
        $stmt = $db->prepare("SELECT project_id FROM firebase_config WHERE is_active = 1 LIMIT 1");
        $stmt->execute();
        $config = $stmt->fetch(PDO::FETCH_ASSOC);
        
        header('Content-Type: application/json');
        echo json_encode([
            'success' => true,
            'config' => $config ?: null
        ]);
        exit();
        
    } catch (Exception $e) {
        header('Content-Type: application/json');
        echo json_encode([
            'success' => false,
            'message' => 'Ayarlar getirilemedi: ' . $e->getMessage()
        ]);
        exit();
    }
}

// POST isteği - Ayarları kaydet
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $projectId = trim($_POST['project_id'] ?? '');
        $serviceAccountJson = trim($_POST['service_account_json'] ?? '');
        
        // Validasyon
        if (empty($projectId)) {
            throw new Exception("Project ID gereklidir");
        }
        
        if (empty($serviceAccountJson)) {
            throw new Exception("Service Account JSON gereklidir");
        }
        
        // JSON formatını kontrol et
        $serviceAccount = json_decode($serviceAccountJson, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Geçersiz JSON formatı: " . json_last_error_msg());
        }
        
        // Gerekli alanları kontrol et
        $requiredFields = [
            'type', 'project_id', 'private_key_id', 'private_key', 
            'client_email', 'client_id', 'auth_uri', 'token_uri',
            'auth_provider_x509_cert_url', 'client_x509_cert_url'
        ];
        
        foreach ($requiredFields as $field) {
            if (!isset($serviceAccount[$field]) || empty($serviceAccount[$field])) {
                throw new Exception("Service Account JSON'da eksik alan: $field");
            }
        }
        
        // Service account type kontrolü
        if ($serviceAccount['type'] !== 'service_account') {
            throw new Exception("Geçersiz service account türü. 'service_account' olmalıdır.");
        }
        
        // Project ID eşleşme kontrolü
        if ($serviceAccount['project_id'] !== $projectId) {
            throw new Exception("Project ID ile Service Account JSON'daki project_id eşleşmiyor");
        }
        
        // Mevcut aktif konfigürasyonu pasif yap
        $stmt = $db->prepare("UPDATE firebase_config SET is_active = 0");
        $stmt->execute();
        
        // Yeni konfigürasyonu kaydet
        $stmt = $db->prepare("
            INSERT INTO firebase_config (project_id, service_account_json, is_active) 
            VALUES (?, ?, 1)
        ");
        
        $stmt->execute([
            $projectId,
            $serviceAccountJson
        ]);
        
        $_SESSION['success_message'] = 'Firebase ayarları başarıyla kaydedildi';
        
        // AJAX isteği ise JSON döndür
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 
            strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
            header('Content-Type: application/json');
            echo json_encode([
                'success' => true,
                'message' => 'Firebase ayarları başarıyla kaydedildi'
            ]);
            exit();
        }
        
        // Normal form isteği ise yönlendir
        header('Location: notifications.php');
        exit();
        
    } catch (Exception $e) {
        $_SESSION['error_message'] = $e->getMessage();
        
        // AJAX isteği ise JSON döndür
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && 
            strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest') {
            header('Content-Type: application/json');
            echo json_encode([
                'success' => false,
                'message' => $e->getMessage()
            ]);
            exit();
        }
        
        // Normal form isteği ise yönlendir
        header('Location: notifications.php');
        exit();
    }
}

// Geçersiz istek
header('Content-Type: application/json');
echo json_encode([
    'success' => false,
    'message' => 'Geçersiz istek'
]);
