</div>
            <!-- Content Area End -->
        </main>
        <!-- Main Content End -->
    </div>
    <!-- Admin Container End -->
    
    <!-- JavaScript Files -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    
    <!-- Custom JavaScript -->
    <script>
        // Admin Panel JavaScript Functions
        
        // Alert auto hide
        $(document).ready(function() {
            setTimeout(function() {
                $('.alert').fadeOut('slow');
            }, 5000);
        });
        
        // Confirm delete
        function confirmDelete(message = 'Bu öğeyi silmek istediğinizden emin misiniz?') {
            return confirm(message);
        }
        
        // File upload preview
        function previewImage(input, previewId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#' + previewId).attr('src', e.target.result).show();
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        
        // Form validation
        function validateForm(formId) {
            var isValid = true;
            $('#' + formId + ' .form-control[required]').each(function() {
                if ($(this).val().trim() === '') {
                    $(this).addClass('error');
                    isValid = false;
                } else {
                    $(this).removeClass('error');
                }
            });
            return isValid;
        }
        
        // Loading button
        function showLoading(buttonId) {
            $('#' + buttonId).html('<span class="loading"></span> İşleniyor...').prop('disabled', true);
        }
        
        function hideLoading(buttonId, originalText) {
            $('#' + buttonId).html(originalText).prop('disabled', false);
        }
        
        // Mobile sidebar toggle
        function toggleSidebar() {
            $('.sidebar').toggleClass('active');
        }
        
        // Auto resize textarea
        $('textarea').on('input', function() {
            this.style.height = 'auto';
            this.style.height = (this.scrollHeight) + 'px';
        });
        
        // Character counter for text fields
        $('.form-control[data-max-length]').on('input', function() {
            var maxLength = $(this).data('max-length');
            var currentLength = $(this).val().length;
            var counterId = $(this).attr('id') + '_counter';
            
            if ($('#' + counterId).length === 0) {
                $(this).after('<small id="' + counterId + '" class="text-muted"></small>');
            }
            
            $('#' + counterId).text(currentLength + '/' + maxLength + ' karakter');
            
            if (currentLength > maxLength) {
                $(this).addClass('error');
                $('#' + counterId).addClass('text-danger');
            } else {
                $(this).removeClass('error');
                $('#' + counterId).removeClass('text-danger');
            }
        });
        
        // AJAX form submission
        function submitAjaxForm(formId, successCallback, errorCallback) {
            var formData = new FormData($('#' + formId)[0]);
            
            $.ajax({
                url: $('#' + formId).attr('action'),
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    if (typeof successCallback === 'function') {
                        successCallback(response);
                    }
                },
                error: function(xhr, status, error) {
                    if (typeof errorCallback === 'function') {
                        errorCallback(xhr, status, error);
                    }
                }
            });
        }
        
        // Data table search
        function searchTable(searchInput, tableId) {
            var filter = $(searchInput).val().toUpperCase();
            var table = $('#' + tableId);
            var rows = table.find('tbody tr');
            
            rows.each(function() {
                var row = $(this);
                var text = row.text().toUpperCase();
                
                if (text.indexOf(filter) > -1) {
                    row.show();
                } else {
                    row.hide();
                }
            });
        }
        
        // Sort table
        function sortTable(tableId, columnIndex, isNumeric = false) {
            var table = $('#' + tableId);
            var rows = table.find('tbody tr').toArray();
            
            rows.sort(function(a, b) {
                var aVal = $(a).find('td').eq(columnIndex).text();
                var bVal = $(b).find('td').eq(columnIndex).text();
                
                if (isNumeric) {
                    return parseFloat(aVal) - parseFloat(bVal);
                } else {
                    return aVal.localeCompare(bVal, 'tr');
                }
            });
            
            table.find('tbody').empty().append(rows);
        }
    </script>
    
    <!-- Custom Page JavaScript -->
    <?php if (isset($custom_js)): ?>
        <?php foreach ($custom_js as $js): ?>
            <script src="<?php echo $js; ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <!-- Inline JavaScript -->
    <?php if (isset($inline_js)): ?>
        <script>
            <?php echo $inline_js; ?>
        </script>
    <?php endif; ?>
</body>
</html>
