<?php
/**
 * Firebase Bildirim Test Scripti
 * Firebase bildirim gönderme işlemini test eder
 */

session_start();
require_once 'config/database.php';
require_once 'includes/FirebaseService.php';

echo "Firebase Bildirim Test Başlıyor...\n\n";

// Test admin session'ı oluştur
$_SESSION['admin_id'] = 1;
$_SESSION['username'] = 'admin';

try {
    // Database bağlantısı
    $database = new Database();
    $db = $database->getConnection();
    echo "✅ Database bağlantısı başarılı\n\n";
    
    // Firebase Service oluştur
    echo "Firebase Service oluşturuluyor...\n";
    $firebaseService = new FirebaseService($db);
    echo "✅ Firebase Service oluşturuldu\n\n";
    
    // Firebase yapılandırması kontrolü
    echo "Firebase yapılandırması kontrol ediliyor...\n";
    $isConfigured = $firebaseService->isConfigured();
    
    if ($isConfigured) {
        echo "✅ Firebase yapılandırması mevcut\n\n";
        
        // Test bildirim gönder
        echo "Test bildirim gönderiliyor...\n";
        echo "Hedef: all_users topic\n";
        echo "Başlık: Test Bildirimi\n";
        echo "Mesaj: Bu bir test bildirimidir\n\n";
        
        $result = $firebaseService->sendToTopic(
            'all_users',
            'Test Bildirimi',
            'Bu bir test bildirimidir',
            'ic_notification',
            'default',
            null
        );
        
        echo "Bildirim gönderme sonucu:\n";
        echo "========================\n";
        echo "Success: " . ($result['success'] ? 'true' : 'false') . "\n";
        echo "Message: " . $result['message'] . "\n";
        
        if (isset($result['error'])) {
            echo "Error: " . $result['error'] . "\n";
        }
        
        if (isset($result['response'])) {
            echo "Response: " . json_encode($result['response'], JSON_PRETTY_PRINT) . "\n";
        }
        
        echo "\n";
        
        // Bildirim geçmişine kaydet
        if (isset($result)) {
            echo "Bildirim geçmişe kaydediliyor...\n";
            $historyId = $firebaseService->saveNotificationHistory(
                null, // template_id
                'Test Bildirimi',
                'Bu bir test bildirimidir',
                'ic_notification',
                'default',
                null, // click_action
                'topic',
                'all_users',
                $result,
                $_SESSION['admin_id']
            );
            
            if ($historyId) {
                echo "✅ Bildirim geçmişe kaydedildi (ID: $historyId)\n";
            } else {
                echo "❌ Bildirim geçmişe kaydedilemedi\n";
            }
        }
        
    } else {
        echo "❌ Firebase yapılandırması eksik\n";
        echo "Firebase ayarlarını yapılandırmanız gerekiyor.\n";
    }
    
} catch (Exception $e) {
    echo "❌ HATA: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "\n" . str_repeat("=", 50) . "\n";
echo "Test tamamlandı.\n";
